NAVMongo.prototype.getDB = function (databaseName) {
    if (isUndefined(databaseName))
        nav_throwError("mongo.getDB should have database name");
    if (!isString(databaseName))
        nav_throwError("database name should be string");

    return this.forwardToCustomFunction("mongoGetDB", databaseName);
};

NAVMongo.prototype.getDBNames = function () {
    return this.getDBs().databases.map(function (dbObj) {
        return dbObj.name;
    });
};

NAVMongo.prototype.getDBs = function () {
    var command = { listDatabases: 1 };

    const result = db.adminCommand(command);
    if (!result.ok)
        nav_throwError(result.errmsg, result);

    return result;
};

NAVMongo.prototype.getReadPrefMode = function () {
    return this.forwardToCustomFunction("mongoGetReadPrefMode");
};

NAVMongo.prototype.getReadPrefTagSet = function () {
    return this.forwardToCustomFunction("mongoGetReadPrefTagSet");
};

NAVMongo.prototype.getWriteConcern = function () {
    return this.forwardToCustomFunction("mongoGetWriteConcern");
};

NAVMongo.prototype.setReadPref = function (mode, tagSet, hedgeOptions) {
    if (isUndefined(mode))
        nav_throwError("mongo.setReadPref requires parameter 'mode'")
    if (!isString(mode))
        nav_throwError("mongo.setReadPref requires 'mode' in string format");
    if (!isUndefined(tagSet)) {
        if (!isObject(tagSet)) {
            nav_throwError("mongo.setReadPref requires 'tagSet' in object format");
        }
    }
    if (!isUndefined(hedgeOptions)) {
        if (!isObject(hedgeOptions)) {
            nav_throwError("mongo.setReadPref requires 'hedgeOptions' in object format");
        }
    }

    if (this.getReadPrefMode() === "primary") {
        if (!isUndefined(tagSet) && tagSet && (Object.keys(tagSet).length > 0))
            nav_throwError("Cannot supply tagSet with readPref mode primary");
        if (isObject(hedgeOptions) && hedgeOptions.enabled)
            nav_throwError("Cannot enable hedging with readPref mode primary");
    }

    this.forwardToCustomFunction("mongoSetReadPref", mode, tagSet, hedgeOptions);
};

NAVMongo.prototype.setSlaveOk = function (value) {
    this.forwardToCustomFunction("mongoSetSlaveOk", value);
};

NAVMongo.prototype.setWriteConcern = function (writeConcern) {
    if (!isObject(writeConcern) && !isNumber(writeConcern) && !isString(writeConcern))
        nav_throwError("w value must be a number or string");

    if (isNumber(writeConcern)) {
        writeConcern = { w: writeConcern };
    } else if (isString(writeConcern)) {
        writeConcern = { w: writeConcern };
    }
    
    var w = writeConcern.w;
    var wtimeout = writeConcern.wtimeout;
    var j = writeConcern.j;

    this.forwardToCustomFunction("mongoSetWriteConcern", w, wtimeout, j);
};

NAVMongo.prototype.startSession = function (options) {
    options = Object.extend({}, options || {});

    var causalConsistency = options.causalConsistency;

    var readConcern = options.readConcern;
    var level = undefined;
    if (readConcern) {
        if (isString(readConcern))
            level = readConcern;
        else
            level = readConcern.level;
    }

    var readPref = options.readPreference;
    var mode = readPref ? readPref.mode : undefined;
    var tags = readPref ? readPref.tags : undefined;

    var retryWrites = options.retryWrites;

    var writeConcern = options.writeConcern;

    return this.forwardToCustomFunction("mongoStartSession", causalConsistency, level, mode, tags, retryWrites, writeConcern);
};

NAVMongo.prototype.watch = function (pipeline, options) {
    var tmpPipeline = Object.extend([], (pipeline || []));
    var tmpOptions = Object.extend({}, (options || {}));
    if (!tmpPipeline instanceof Array)
        nav_throwError("pipeline should be array");
    if (!tmpOptions instanceof Object)
        nav_throwError("options should be object");

    var changeStreamStage = { fullDocument: tmpOptions.fullDocument || "default" };
    delete tmpOptions.fullDocument;

    if (tmpOptions.hasOwnProperty("resumeAfter")) {
        changeStreamStage.resumeAfter = tmpOptions.resumeAfter;
        delete tmpOptions.resumeAfter;
    }

    if (tmpOptions.hasOwnProperty("startAfter")) {
        changeStreamStage.startAfter = tmpOptions.startAfter;
        delete tmpOptions.startAfter;
    }

    if (tmpOptions.hasOwnProperty("fullDocumentBeforeChange")) {
        changeStreamStage.fullDocumentBeforeChange = tmpOptions.fullDocumentBeforeChange;
        delete tmpOptions.fullDocumentBeforeChange;
    }

    if (tmpOptions.hasOwnProperty("allChangesForCluster")) {
        changeStreamStage.allChangesForCluster = tmpOptions.allChangesForCluster;
        delete tmpOptions.allChangesForCluster;
    }

    if (tmpOptions.hasOwnProperty("allowToRunOnConfigDB")) {
        changeStreamStage.allowToRunOnConfigDB = tmpOptions.allowToRunOnConfigDB;
        delete tmpOptions.allowToRunOnConfigDB;
    }

    if (tmpOptions.hasOwnProperty("allowToRunOnSystemNS")) {
        changeStreamStage.allowToRunOnSystemNS = tmpOptions.allowToRunOnSystemNS;
        delete tmpOptions.allowToRunOnSystemNS;
    }

    if (tmpOptions.hasOwnProperty("startAtOperationTime")) {
        changeStreamStage.startAtOperationTime = tmpOptions.startAtOperationTime;
        delete tmpOptions.startAtOperationTime;
    }

    if (options.hasOwnProperty("showExpandedEvents")) {
        changeStreamStage.showExpandedEvents = tmpOptions.showExpandedEvents;
        delete tmpOptions.showExpandedEvents;
    }

    if (options.hasOwnProperty("showSystemEvents")) {
        changeStreamStage.showSystemEvents = tmpOptions.showSystemEvents;
        delete tmpOptions.showSystemEvents;
    }

    if (options.hasOwnProperty("showRawUpdateDescription")) {
        changeStreamStage.showRawUpdateDescription = tmpOptions.showRawUpdateDescription;
        delete tmpOptions.showRawUpdateDescription;
    }

    tmpPipeline.unshift({ $changeStream: changeStreamStage });
    return this.getDB("admin").aggregate(tmpPipeline, tmpOptions);
};
